/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.others.GifButton;
import graphics.screens.Screen;
import graphics.vars.GraphicsVariables;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import util.Utilities;

public class CharacChoiceScreen
extends Screen {
    public final Color DEFAULT_SCREEN_COLOR = new Color(0, 255, 255);
    public boolean timeToSwitchImage = false;
    public boolean responseMade = false;
    private Point mousePoint = new Point();
    public boolean responseHandled = false;
    public static final int NUMBER_CHARACTERS = 6;
    public static final boolean[] DEFAULT_ACCESS_PARAMS;
    public GifButton charac1Button;
    public GifButton charac2Button;
    public GifButton charac3Button;
    public GifButton charac4Button;
    public GifButton charac5Button;
    public GifButton charac6Button;

    static {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        DEFAULT_ACCESS_PARAMS = blArray;
    }

    public CharacChoiceScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.hasSounds = true;
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
        this.hasBackgroundImages = true;
        this.backgroundImageFiles = new String[1];
        this.backgroundImageFiles[0] = game.themeVars.characChoiceBackground;
        this.charac1Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_1_BUTTON_LOC, game.themeVars.charac_1_files);
        this.charac2Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_2_BUTTON_LOC, game.themeVars.charac_2_files);
        this.charac3Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_3_BUTTON_LOC, game.themeVars.charac_3_files);
        this.charac4Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_4_BUTTON_LOC, game.themeVars.charac_4_files);
        this.charac5Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_5_BUTTON_LOC, game.themeVars.charac_5_files);
        this.charac6Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_6_BUTTON_LOC, game.themeVars.charac_6_files);
    }

    @Override
    public void load() {
        super.load();
        this.charac1Button.load();
        this.charac2Button.load();
        this.charac3Button.load();
        this.charac4Button.load();
        this.charac5Button.load();
        this.charac6Button.load();
        this.loadingEnd();
    }

    @Override
    public void start() {
        this.game.soundManager.stopAllSounds();
        boolean characterUnlocked = this.game.currentStudent.checkForCharacterUnlock(this.game.getTheme());
        if (characterUnlocked) {
            this.game.currentStudent.unlockNextCharacter(this, this.game.getTheme());
            this.setRendered(false);
            this.game.soundManager.play("unlockedCharacter");
            this.game.delay(3500, "game.soundManager.play(\"chooseCharacter\")");
        } else {
            this.game.soundManager.play("chooseCharacter");
        }
        super.start();
    }

    @Override
    public void process() {
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            Graphics2D g2D = (Graphics2D)g;
            super.render(g);
            if (!this.loading) {
                this.charac2Button.paint(g2D);
                this.charac1Button.paint(g2D);
                this.charac3Button.paint(g2D);
                this.charac4Button.paint(g2D);
                this.charac5Button.paint(g2D);
                this.charac6Button.paint(g2D);
                g2D.setColor(this.game.themeVars.textColor);
                g2D.setFont(this.game.themeVars.characChoiceTitleFont);
                Utilities.drawFromPoint("Scegli il tuo personaggio", GraphicsVariables.CHARAC_CHOICE_TITLE_LOC, 0, -1, g2D);
                g2D.setFont(this.game.themeVars.characChoiceLabelFont);
                if (this.game.currentStudent.getCharacAccess(0, this.game.getTheme())) {
                    Utilities.drawFromPoint(this.game.themeVars.charac1Label, GraphicsVariables.CHARAC_1_TITLE_LOC, -1, -1, g2D);
                } else {
                    Utilities.drawFromPoint("Bloccato", GraphicsVariables.CHARAC_1_TITLE_LOC, -1, -1, g2D);
                }
                if (this.game.currentStudent.getCharacAccess(1, this.game.getTheme())) {
                    Utilities.drawFromPoint(this.game.themeVars.charac2Label, GraphicsVariables.CHARAC_2_TITLE_LOC, -1, -1, g2D);
                } else {
                    Utilities.drawFromPoint("Bloccato", GraphicsVariables.CHARAC_2_TITLE_LOC, -1, -1, g2D);
                }
                if (this.game.currentStudent.getCharacAccess(2, this.game.getTheme())) {
                    Utilities.drawFromPoint(this.game.themeVars.charac3Label, GraphicsVariables.CHARAC_3_TITLE_LOC, -1, -1, g2D);
                } else {
                    Utilities.drawFromPoint("Bloccato", GraphicsVariables.CHARAC_3_TITLE_LOC, -1, -1, g2D);
                }
                if (this.game.currentStudent.getCharacAccess(3, this.game.getTheme())) {
                    Utilities.drawFromPoint(this.game.themeVars.charac4Label, GraphicsVariables.CHARAC_4_TITLE_LOC, -1, -1, g2D);
                } else {
                    Utilities.drawFromPoint("Bloccato", GraphicsVariables.CHARAC_4_TITLE_LOC, -1, -1, g2D);
                }
                if (this.game.currentStudent.getCharacAccess(4, this.game.getTheme())) {
                    Utilities.drawFromPoint(this.game.themeVars.charac5Label, GraphicsVariables.CHARAC_5_TITLE_LOC, -1, -1, g2D);
                } else {
                    Utilities.drawFromPoint("Bloccato", GraphicsVariables.CHARAC_5_TITLE_LOC, -1, -1, g2D);
                }
                if (this.game.currentStudent.getCharacAccess(5, this.game.getTheme())) {
                    Utilities.drawFromPoint(this.game.themeVars.charac6Label, GraphicsVariables.CHARAC_6_TITLE_LOC, -1, -1, g2D);
                } else {
                    Utilities.drawFromPoint("Bloccato", GraphicsVariables.CHARAC_6_TITLE_LOC, -1, -1, g2D);
                }
                this.setPainted(false);
            } else if (this.loading) {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    public void themeChanged() {
        this.backgroundImageFiles[0] = this.game.themeVars.characChoiceBackground;
        this.charac1Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_1_BUTTON_LOC, this.game.themeVars.charac_1_files);
        this.charac2Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_2_BUTTON_LOC, this.game.themeVars.charac_2_files);
        this.charac3Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_3_BUTTON_LOC, this.game.themeVars.charac_3_files);
        this.charac4Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_4_BUTTON_LOC, this.game.themeVars.charac_4_files);
        this.charac5Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_5_BUTTON_LOC, this.game.themeVars.charac_5_files);
        this.charac6Button = new GifButton((Screen)this, GraphicsVariables.CHARAC_6_BUTTON_LOC, this.game.themeVars.charac_6_files);
        this.setRendered(false);
    }

    @Override
    public void unload() {
        super.unload();
        this.charac1Button.unload();
        this.charac2Button.unload();
        this.charac3Button.unload();
        this.charac4Button.unload();
        this.charac5Button.unload();
        this.charac6Button.unload();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.respondOnEvent) {
            int responseButton = e.getButton();
            this.mousePoint.setLocation(e.getX(), e.getY());
            int characterSelected = 9;
            boolean wasCharacSelected = false;
            boolean validCharacSelected = false;
            if (this.charac1Button.isPointInBounds(this.mousePoint)) {
                wasCharacSelected = true;
                if (this.game.currentStudent.getCharacAccess(0, this.game.getTheme())) {
                    this.charac1Button.selected();
                    characterSelected = 0;
                    validCharacSelected = true;
                }
            } else if (this.charac2Button.isPointInBounds(this.mousePoint)) {
                wasCharacSelected = true;
                if (this.game.currentStudent.getCharacAccess(1, this.game.getTheme())) {
                    this.charac2Button.selected();
                    characterSelected = 1;
                    validCharacSelected = true;
                }
            } else if (this.charac3Button.isPointInBounds(this.mousePoint)) {
                wasCharacSelected = true;
                if (this.game.currentStudent.getCharacAccess(2, this.game.getTheme())) {
                    this.charac3Button.selected();
                    characterSelected = 2;
                    validCharacSelected = true;
                }
            } else if (this.charac4Button.isPointInBounds(this.mousePoint)) {
                wasCharacSelected = true;
                if (this.game.currentStudent.getCharacAccess(3, this.game.getTheme())) {
                    this.charac4Button.selected();
                    characterSelected = 3;
                    validCharacSelected = true;
                }
            } else if (this.charac5Button.isPointInBounds(this.mousePoint)) {
                wasCharacSelected = true;
                if (this.game.currentStudent.getCharacAccess(4, this.game.getTheme())) {
                    this.charac5Button.selected();
                    characterSelected = 4;
                    validCharacSelected = true;
                }
            } else if (this.charac6Button.isPointInBounds(this.mousePoint)) {
                wasCharacSelected = true;
                if (this.game.currentStudent.getCharacAccess(5, this.game.getTheme())) {
                    this.charac6Button.selected();
                    characterSelected = 5;
                    validCharacSelected = true;
                }
            }
            if (validCharacSelected) {
                this.respondOnEvent = false;
                this.game.choiceScreen.playerIcons[0].setCharacter(characterSelected);
                this.game.choiceScreen.boardScreen.players[0].setCharacter(characterSelected);
                this.game.delay(1000, "game.changeCurrentScreen(game.choiceScreen)");
            } else if (wasCharacSelected) {
                this.game.soundManager.stopAllSounds();
                this.game.soundManager.play("characterLocked");
                this.game.delay(1400, "game.soundManager.play(\"winToUnlock\")");
            }
        }
    }
}

