/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.managers.HazardManager;
import graphics.others.GifButton;
import graphics.others.NumberBoard;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.PlayerPiece;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;

public class BoardScreen
extends Screen {
    private ChoiceScreen choiceScreen;
    public Game game;
    public NumberBoard numberBoard;
    public HazardManager hazardManager;
    public PlayerPiece[] players;
    private GifButton choiceButton;
    private GifButton menuButton;
    private StringBuffer lblDebugAlg;
    private Point mousePoint = new Point();
    public byte responseMode = 0;

    public BoardScreen(Rectangle bounds, Game game, ChoiceScreen choiceScreen, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.choiceScreen = choiceScreen;
        this.game = game;
        this.setBackground(game.themeVars.screenColor);
        this.hasAnimations = true;
        this.numberBoard = new NumberBoard(this, choiceScreen, 32, 256, 960, 512, 90, 4, 16, 32);
        this.hazardManager = new HazardManager(this, choiceScreen, game, this.numberBoard);
        this.players = new PlayerPiece[2];
        this.players[0] = new PlayerPiece(this, choiceScreen, 0, new Point(192, 80), 90.0, 0, 0);
        this.players[1] = new PlayerPiece(this, choiceScreen, 0, new Point(192, 176), 90.0, 1, 0);
        String[] fileNames = new String[]{game.themeVars.choiceButton, game.themeVars.choiceButton};
        this.choiceButton = new GifButton((Screen)choiceScreen, new Point(960, 64), fileNames);
        this.menuButton = choiceScreen.menuButton;
        this.lblDebugAlg = new StringBuffer(100);
        this.hasSounds = true;
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
    }

    @Override
    public void load() {
        super.load();
        this.numberBoard.load();
        this.hazardManager.load();
        this.players[0].load();
        this.players[1].load();
        this.choiceButton.load();
        this.menuButton.load();
        this.animationList.add(this.choiceScreen.ncm);
        this.animationList.add(this.numberBoard);
        this.animationList.add(this.choiceScreen.dotCarpet);
        this.animationList.add(this.hazardManager);
        this.animationList.add(this.choiceScreen.dotManagers[0]);
        this.animationList.add(this.choiceScreen.dotManagers[1]);
        this.animationList.add(this.choiceScreen.playerIcons[0]);
        this.animationList.add(this.choiceScreen.playerIcons[1]);
        this.animationList.add(this.players[0]);
        this.animationList.add(this.players[1]);
        this.numberBoard.setVisible(true);
        this.players[0].setVisible(true);
        this.players[1].setVisible(true);
        this.loadingEnd();
    }

    @Override
    public void start() {
        this.game.soundManager.stopAllSounds();
        this.choiceScreen.dotManagers[0].switchDrawingScreen("BOARD_SCREEN");
        this.choiceScreen.dotManagers[1].switchDrawingScreen("BOARD_SCREEN");
        super.start();
        this.hazardManager.start();
    }

    public void resetTurn() {
        this.responseMode = (byte)4;
        this.numberBoard.resetTurn();
        this.players[0].resetTurn();
        this.players[1].resetTurn();
        this.hazardManager.resetTurn();
        this.choiceScreen.playerIcons[0].reset();
        this.choiceScreen.playerIcons[1].reset();
    }

    public void resetGame() {
        this.responseMode = 0;
        this.setLblDebugAlg("");
        this.setLblTranslation("");
        this.players[0].resetGame();
        this.players[1].resetGame();
        this.hazardManager.resetGame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.readyToProcess) {
            AnimatedObject animation = null;
            List list = this.animationList;
            synchronized (list) {
                int i = 0;
                while (i < this.animationList.size()) {
                    animation = (AnimatedObject)this.animationList.get(i);
                    if (animation.isActive()) {
                        animation.animate(this);
                    }
                    if (animation.isImageActive()) {
                        animation.animateImage(this);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            this.setRendered(true);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setColor(this.game.themeVars.screenColor);
            g2D.fill(this.getBounds());
            if (!this.loading) {
                AnimatedObject animatedObject = null;
                int i = 0;
                while (i < this.animationList.size()) {
                    animatedObject = (AnimatedObject)this.animationList.get(i);
                    animatedObject.paint(g2D);
                    ++i;
                }
                this.choiceButton.paint(g2D);
                this.menuButton.paint(g2D);
                this.setPainted(false);
            } else {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    public void themeChanged() {
        this.numberBoard.themeChanged();
        this.hazardManager.themeChanged();
        this.players[0].themeChanged();
        this.players[1].themeChanged();
        String[] fileNames = new String[]{this.game.themeVars.choiceButton, this.game.themeVars.choiceButton};
        this.choiceButton = new GifButton((Screen)this.choiceScreen, new Point(960, 64), fileNames);
        this.menuButton = this.choiceScreen.menuButton;
        this.choiceButton.load();
        this.menuButton.load();
        this.setRendered(false);
    }

    @Override
    public void unload() {
        super.unload();
        this.numberBoard.unload();
        this.hazardManager.unload();
        this.players = null;
        this.choiceButton = null;
        this.menuButton = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int responseButton = e.getButton();
        this.mousePoint.setLocation(e.getX(), e.getY());
        if (this.responseMode == 4 && this.choiceButton.isPointInBounds(this.mousePoint)) {
            this.responseMode = 0;
            this.game.soundManager.stopAllSounds();
            this.game.removeTasksFromList("soundManager");
            this.choiceButton.selected();
            this.game.delay(1000, "game.changeCurrentScreenNoUnload(choiceScreen)");
        } else if (this.menuButton.isPointInBounds(this.mousePoint)) {
            this.game.soundManager.stopAllSounds();
            this.game.removeTasksFromList("soundManager");
            this.menuButton.selected();
            this.game.callMenu(this);
        } else if (this.numberBoard.isPointInBounds(this.mousePoint) && (this.responseMode == 2 || this.responseMode == 3)) {
            this.choiceScreen.ncm.responseHandler(e);
        }
    }

    public void setLblDebugAlg(String string) {
        this.lblDebugAlg.delete(0, this.lblDebugAlg.capacity());
        this.lblDebugAlg.append(string);
        this.rendered = false;
    }
}

