/*
 * Decompiled with CFR 0.152.
 */
package graphics.others;

import algorithms.GameTurn;
import graphics.Game;
import graphics.others.DotArray;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import util.ImageFactory;
import util.Utilities;

public class DotContainer
extends AnimatedObject {
    private byte id;
    private Game game;
    public ChoiceScreen choiceScreen;
    private int width;
    private int height;
    private int x;
    private int y;
    public DotArray mainDotArray;
    public DotArray[] subDotArrays;
    private boolean selected = false;
    private boolean open = false;
    private BufferedImage offScreenDotContainer;
    private Image closedContainerImage;
    private Image openContainerImage;
    private String[] fileNames;
    private int containerImageX;
    private int containerImageY;
    private int containerImageDiameter;
    public Point[] dotStackPoints = new Point[9];
    private boolean arabicStims = false;
    private boolean verbalStims = false;
    private boolean addition = false;
    private boolean subtraction = false;
    private String lblDigitName;

    public DotContainer(Game game, ChoiceScreen choiceScreen, byte id, int x, int y, String[] fileNames, int width, int height, int imageX, int imageY, int imageDiam, int dotArrayX, int dotArrayY, int dotArrayDiameter, int subDotArrayDiameter, int digitX, int digitY) {
        this.game = game;
        this.choiceScreen = choiceScreen;
        this.id = id;
        this.setWidth(width);
        this.setHeight(height);
        this.setX(x);
        this.setY(y);
        this.containerImageX = imageX;
        this.containerImageY = imageY;
        this.containerImageDiameter = imageDiam;
        this.mainDotArray = new DotArray(game, choiceScreen, this, id, dotArrayX, dotArrayY, dotArrayDiameter, dotArrayDiameter);
        this.subDotArrays = new DotArray[2];
        if (id == 0) {
            this.subDotArrays[0] = new DotArray(game, choiceScreen, this, id, 192, 192, subDotArrayDiameter, subDotArrayDiameter);
            this.subDotArrays[1] = new DotArray(game, choiceScreen, this, id, 0, 0, subDotArrayDiameter, subDotArrayDiameter);
        } else if (id == 1) {
            this.subDotArrays[0] = new DotArray(game, choiceScreen, this, id, 0, 192, subDotArrayDiameter, subDotArrayDiameter);
            this.subDotArrays[1] = new DotArray(game, choiceScreen, this, id, 192, 0, subDotArrayDiameter, subDotArrayDiameter);
        }
        this.fileNames = fileNames;
    }

    private void calculatePointLocations() {
        block3: {
            int interDotInterval;
            block2: {
                interDotInterval = (int)(this.mainDotArray.getConvertedMaxR() * 2.0);
                if (this.id != 0) break block2;
                int i = 0;
                while (i < 9) {
                    this.dotStackPoints[i] = i % 2 == 0 ? new Point(this.x + 416 - (int)(Math.floor(i / 2) * (double)interDotInterval), this.y + 416) : new Point(this.x + 416 - (int)(Math.floor(i / 2) * (double)interDotInterval), this.y + 416 - interDotInterval);
                    ++i;
                }
                break block3;
            }
            if (this.id != 1) break block3;
            int i = 0;
            while (i < 9) {
                this.dotStackPoints[i] = i % 2 == 0 ? new Point(this.x + 32 + (int)(Math.floor(i / 2) * (double)interDotInterval), this.y + 416) : new Point(this.x + 32 + (int)(Math.floor(i / 2) * (double)interDotInterval), this.y + 416 - interDotInterval);
                ++i;
            }
        }
    }

    @Override
    public void load() {
        this.offScreenDotContainer = (BufferedImage)Utilities.createImage(this.choiceScreen, this.width, this.height);
        this.loadContainerImages();
        this.mainDotArray.load();
        this.subDotArrays[0].load();
        this.subDotArrays[1].load();
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        this.mainDotArray.unload();
        this.subDotArrays[0].unload();
        this.subDotArrays[1].unload();
        this.dotStackPoints = null;
        this.offScreenDotContainer = null;
        this.closedContainerImage = null;
        this.openContainerImage = null;
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    private void loadContainerImages() {
        this.closedContainerImage = ImageFactory.getCompatibleImage(this.fileNames[0], this.choiceScreen.gc, 2);
        this.openContainerImage = ImageFactory.getCompatibleImage(this.fileNames[1], this.choiceScreen.gc, 2);
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive()) {
            this.mainDotArray.animate(screen);
        }
    }

    private void render() {
        this.setRendered(true);
        Graphics2D g2D = (Graphics2D)this.offScreenDotContainer.getGraphics();
        g2D.setColor(this.game.themeVars.dotContColor);
        g2D.fillRect(0, 0, this.width, this.height);
        if (this.open) {
            g2D.drawImage(this.openContainerImage, this.containerImageX, this.containerImageY, this.containerImageDiameter, this.containerImageDiameter, null);
            if (this.addition) {
                this.subDotArrays[0].paint(g2D);
                this.subDotArrays[1].paint(g2D);
            } else {
                this.mainDotArray.paint(g2D);
            }
        } else if (!this.open) {
            g2D.drawImage(this.closedContainerImage, this.containerImageX, this.containerImageY, this.containerImageDiameter, this.containerImageDiameter, null);
        }
        if (this.arabicStims) {
            g2D.setColor(this.game.themeVars.dotContDigitColor);
            g2D.setFont(this.game.themeVars.dotContDigitFont);
            if (!this.addition && !this.subtraction) {
                if (this.id == 0) {
                    Utilities.drawFromPoint(this.lblDigitName, 48, 48, 0, 0, g2D);
                } else if (this.id == 1) {
                    Utilities.drawFromPoint(this.lblDigitName, 400, 48, 0, 0, g2D);
                }
            } else if (this.id == 0) {
                Utilities.drawFromPoint(this.lblDigitName, 268, 48, 0, 0, g2D);
            } else if (this.id == 1) {
                Utilities.drawFromPoint(this.lblDigitName, 180, 48, 0, 0, g2D);
            }
        }
        g2D.dispose();
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            if (!this.isRendered()) {
                this.render();
            }
            g.drawImage(this.offScreenDotContainer, this.x, this.y, this.width, this.height, null);
        }
    }

    public void openContainer() {
        if (!this.open) {
            this.setOpen(true);
            String soundKey = "chestOpen";
            this.game.soundManager.play(soundKey);
        }
    }

    public void select() {
        this.selected = true;
        this.choiceScreen.dotContainers[Utilities.oppositeSide(this.id)].setActive(false);
        boolean graphicsChange = false;
        if (!this.open) {
            this.openContainer();
            graphicsChange = true;
        }
        if (!this.mainDotArray.getDotsVisible()) {
            this.mainDotArray.setDotsVisible(true);
        }
        if (!this.subDotArrays[0].getDotsVisible()) {
            this.subDotArrays[0].setDotsVisible(true);
        }
        if (!this.subDotArrays[1].getDotsVisible()) {
            this.subDotArrays[1].setDotsVisible(true);
        }
        if (this.mainDotArray.getDotsFade()) {
            this.mainDotArray.setDotsFade(false);
        }
        if (graphicsChange) {
            this.update();
        }
    }

    public void playVerbalStims(int characterID) {
        GameTurn currentTurn = this.game.choiceScreen.ncm.getCurrentTurn();
        int[] numbers = currentTurn.getNumbers();
        int[][] subNumbers = currentTurn.getSubNumbers();
        if (this.addition) {
            this.game.soundManager.play(String.valueOf(Utilities.charac4id(characterID)) + Utilities.getVerbalForArabic(subNumbers[this.id][0]));
            this.game.delay(1000, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + "plus\")");
            this.game.delay(1600, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + Utilities.getVerbalForArabic(subNumbers[this.id][1]) + "\")");
            this.game.delay(2600, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + "equals\")");
            this.game.delay(3200, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + Utilities.getVerbalForArabic(numbers[this.id]) + "\")");
        } else if (this.subtraction) {
            this.game.delay(0, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + Utilities.getVerbalForArabic(subNumbers[this.id][0]) + "\")");
            this.game.delay(1000, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + "minus\")");
            this.game.delay(1600, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + Utilities.getVerbalForArabic(subNumbers[this.id][1]) + "\")");
            this.game.delay(2600, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + "equals\")");
            this.game.delay(3200, "game.soundManager.play(\"" + Utilities.charac4id(characterID) + Utilities.getVerbalForArabic(numbers[this.id]) + "\")");
        } else {
            this.game.soundManager.play(String.valueOf(Utilities.charac4id(characterID)) + Utilities.getVerbalForArabic(numbers[this.id]));
        }
    }

    public void setFixedDensity(boolean state) {
        this.mainDotArray.setFixedDensity(state);
        this.subDotArrays[0].setFixedDensity(state);
        this.subDotArrays[1].setFixedDensity(state);
    }

    public void setFixedItemSize(boolean state) {
        this.mainDotArray.setFixedItemSize(state);
        this.subDotArrays[0].setFixedItemSize(state);
        this.subDotArrays[1].setFixedItemSize(state);
    }

    public void setArabicDigit(GameTurn currentTurn) {
        this.lblDigitName = "";
        int[][] subNumbers = currentTurn.getSubNumbers();
        this.lblDigitName = this.addition ? new String(String.valueOf(String.valueOf(subNumbers[this.id][0]) + "+" + subNumbers[this.id][1])) : (this.subtraction ? new String(String.valueOf(String.valueOf(subNumbers[this.id][0]) + "-" + subNumbers[this.id][1])) : new String(String.valueOf(currentTurn.getNumber(this.id))));
    }

    public void showSum() {
        int[] numbers = this.choiceScreen.ncm.getCurrentTurn().getNumbers();
        this.lblDigitName = String.valueOf(this.lblDigitName) + String.valueOf("=" + numbers[this.id]);
        this.update();
    }

    public void themeChanged() {
        this.fileNames = this.id == 0 ? this.game.themeVars.leftDotContainerGifs : this.game.themeVars.rightDotContainerGifs;
        this.mainDotArray.themeChanged();
        this.subDotArrays[0].themeChanged();
        this.subDotArrays[1].themeChanged();
        this.loadContainerImages();
        this.update();
    }

    @Override
    public void update() {
        this.setRendered(false);
        this.choiceScreen.setRendered(false);
    }

    public void reset() {
        this.setActive(false);
        this.selected = false;
        this.open = false;
        this.arabicStims = false;
        this.verbalStims = false;
        this.addition = false;
        this.subtraction = false;
        this.lblDigitName = null;
        this.mainDotArray.reset();
        this.subDotArrays[0].reset();
        this.subDotArrays[1].reset();
        this.update();
    }

    public byte getId() {
        return this.id;
    }

    public void setArabicStims(boolean state) {
        this.arabicStims = state;
        this.update();
    }

    public void setVerbalStims(boolean state) {
        this.verbalStims = state;
    }

    public void setAddition(boolean state) {
        this.addition = state;
    }

    public boolean getAddition() {
        return this.addition;
    }

    public void setSubtraction(boolean state) {
        this.subtraction = state;
        this.calculatePointLocations();
    }

    public boolean getSubtraction() {
        return this.subtraction;
    }

    public void setOpen(boolean state) {
        this.mainDotArray.setVisible(true);
        this.mainDotArray.setDotsVisible(true);
        this.subDotArrays[0].setVisible(true);
        this.subDotArrays[0].setDotsVisible(true);
        this.subDotArrays[1].setVisible(true);
        this.subDotArrays[1].setDotsVisible(true);
        this.open = state;
        this.update();
    }

    public boolean isPointInBounds(Point point) {
        return point.x > this.x && point.x < this.x + this.width && point.y > this.y && point.y < this.y + this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setX(int xPos) {
        this.x = xPos;
    }

    public void setY(int yPos) {
        this.y = yPos;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public void setPosition(float x, float y) {
    }

    @Override
    public void setVelocity(float x, float y) {
    }
}

