/*
 * Decompiled with CFR 0.152.
 */
package graphics.others;

import graphics.Game;
import graphics.others.DotContainer;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.DotSprite;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.util.Random;
import org.jmat.data.Matrix;
import org.jmat.data.matrixTools.Shuffle;
import org.jmat.data.matrixTools.Sorting;

public class DotArray
extends AnimatedObject {
    private byte id;
    private Game game;
    public ChoiceScreen choiceScreen;
    public DotContainer dotContainer;
    private boolean drawDotstoDotArray = true;
    private int numberDots;
    public DotSprite[] dotList;
    private int width;
    private int height;
    private int x;
    private int y;
    private Random randomNumber;
    private float fadeAlpha = 1.0f;
    private boolean dotsVisible = false;
    private boolean dotsFade = false;
    private int fadeTime;
    private boolean fixedItemSize;
    private boolean fixedDensity;
    private int maxNumDots;
    private double rmax;
    private double rmin;
    private Matrix gridCoords;
    private double radiusMultiplier;
    private double convertedMaxR;
    private int n_dots;

    public DotArray(Game game, ChoiceScreen choiceScreen, DotContainer dotContainer, byte id, int x, int y, int width, int height) {
        this.game = game;
        this.choiceScreen = choiceScreen;
        this.dotContainer = dotContainer;
        this.id = id;
        this.setWidth(width);
        this.setHeight(height);
        this.setX(x);
        this.setY(y);
        this.setMaxNumDots(10);
    }

    @Override
    public void load() {
        this.randomNumber = new Random();
        this.randomNumber.setSeed(System.currentTimeMillis());
        this.dotList = new DotSprite[this.maxNumDots];
        int i = 0;
        while (i < this.maxNumDots) {
            this.dotList[i] = new DotSprite(this, (byte)i);
            this.dotList[i].load();
            ++i;
        }
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        this.randomNumber = null;
        this.dotList = null;
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive() && this.dotsFade && this.fadeAlpha > 0.0f && this.game.currentScreen == this.choiceScreen) {
            this.fadeAlpha = Math.max(0.0f, this.fadeAlpha - 1.0f / (40.0f * ((float)this.fadeTime / 1000.0f)));
            this.update();
        }
    }

    @Override
    public void paint(Graphics2D g2D) {
        int i;
        if (this.isReady() && this.getVisible() && !this.isRendered()) {
            this.render();
        }
        if (!this.dotsFade && this.dotsVisible && this.drawDotstoDotArray) {
            i = 0;
            while (i < this.numberDots) {
                this.dotList[i].paint(g2D, "DotArray");
                ++i;
            }
        }
        if (this.dotsFade && this.dotsVisible && this.drawDotstoDotArray) {
            g2D.setComposite(AlphaComposite.getInstance(3, this.fadeAlpha));
            i = 0;
            while (i < this.numberDots) {
                this.dotList[i].paint(g2D, "DotArray");
                ++i;
            }
            g2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    private void render() {
        if (!this.isRendered()) {
            this.setRendered(true);
        }
    }

    private void setDotPositions() {
        double scaleFactor;
        double roffset;
        double tmpRandom;
        int maxCoords = this.gridCoords.getRowDimension();
        this.rmax = this.fixedItemSize ? Math.min(1.0 / (double)this.n_dots / 1.7, 0.1) : (this.fixedDensity ? 0.1 : 0.2);
        this.rmin = this.rmax * Math.sqrt(1.0 / (double)this.maxNumDots);
        double r = this.fixedItemSize ? this.rmax : this.rmax * Math.sqrt(1.0 / (double)this.numberDots);
        this.radiusMultiplier = this.getWidth() >> 1;
        this.convertedMaxR = this.rmax * this.radiusMultiplier;
        double convertedR = r * this.radiusMultiplier;
        int usedCoords = Math.round((float)this.numberDots * 1.3f);
        if (usedCoords > maxCoords) {
            usedCoords = maxCoords;
        }
        if (usedCoords == 0) {
            ++usedCoords;
        }
        if (this.fixedDensity) {
            tmpRandom = this.randomNumber.nextDouble();
            roffset = 0.9 * tmpRandom * (1.0 - Math.sqrt((double)usedCoords / (double)maxCoords));
            scaleFactor = 1.0;
        } else {
            roffset = 0.0;
            scaleFactor = 0.9 * Math.sqrt(maxCoords / usedCoords);
        }
        tmpRandom = this.randomNumber.nextDouble();
        double omega = Math.PI * 2 * tmpRandom;
        Matrix offset = new Matrix(1, 2);
        offset.set(0, 0, roffset * Math.sin(omega));
        offset.set(0, 1, roffset * Math.cos(omega));
        Matrix tmp1 = new Matrix(usedCoords, 1);
        int i = 0;
        while (i < usedCoords) {
            tmp1.set(i, 0, i + 1);
            ++i;
        }
        Matrix order = (Matrix)Shuffle.MatrixRows(tmp1);
        tmpRandom = this.randomNumber.nextDouble();
        omega = Math.PI * 2 * tmpRandom;
        Matrix rotmat = new Matrix(2, 2);
        rotmat.set(0, 0, Math.sin(omega));
        rotmat.set(0, 1, Math.cos(omega));
        rotmat.set(1, 0, -1.0 * Math.cos(omega));
        rotmat.set(1, 1, Math.sin(omega));
        rotmat = (Matrix)rotmat.times(scaleFactor);
        int i2 = 0;
        while (i2 < this.numberDots) {
            Matrix startCoords = new Matrix(1, 2);
            startCoords.set(0, 0, this.gridCoords.get((int)(order.get(i2, 0) - 1.0), 0));
            startCoords.set(0, 1, this.gridCoords.get((int)(order.get(i2, 0) - 1.0), 1));
            Matrix indivRandOffset = new Matrix(1, 2);
            tmpRandom = this.randomNumber.nextDouble();
            indivRandOffset.set(0, 0, tmpRandom);
            tmpRandom = this.randomNumber.nextDouble();
            indivRandOffset.set(0, 1, tmpRandom);
            indivRandOffset = (Matrix)indivRandOffset.minus(0.5);
            indivRandOffset = (Matrix)indivRandOffset.times(r);
            Matrix finalCoords = new Matrix(1, 2);
            finalCoords = (Matrix)startCoords.times(rotmat);
            finalCoords.plusEquals(indivRandOffset);
            finalCoords.plusEquals(offset);
            Matrix dotPos = new Matrix(1, 2);
            dotPos.set(0, 0, finalCoords.get(0, 0));
            dotPos.set(0, 1, finalCoords.get(0, 1));
            dotPos.set(0, 0, (dotPos.get(0, 0) + 1.0) * (double)(this.getWidth() >> 1) - convertedR);
            dotPos.set(0, 1, (dotPos.get(0, 1) + 1.0) * (double)(this.getHeight() >> 1) - convertedR);
            double diameter = convertedR * 2.0;
            this.dotList[i2].setPosition((int)dotPos.get(0, 0), (int)dotPos.get(0, 1));
            this.dotList[i2].setSize((int)diameter, (int)diameter);
            this.dotList[i2].setVisible(true);
            ++i2;
        }
        i2 = this.numberDots;
        while (i2 < this.maxNumDots) {
            this.dotList[i2].setVisible(false);
            ++i2;
        }
        this.update();
    }

    private void setNewDotGrid() {
        boolean minNumDots = true;
        int ndesired = Math.round((float)this.maxNumDots * 1.3f);
        int n = Math.round((float)Math.sqrt(ndesired));
        int loopCounter = 1;
        while (true) {
            int numCoords = (n + 1) * (n + 1);
            Matrix initialCoords = new Matrix(numCoords, 2);
            int a = 0;
            int i = 0;
            while (i <= n) {
                int j = 0;
                while (j <= n) {
                    double iDouble = i;
                    double jDouble = j;
                    double nDouble = n;
                    int iHalf = i >> 1;
                    int nHalf = n >> 1;
                    int jHalf = j >> 1;
                    initialCoords.set(a, 0, ((double)(i - nHalf) + (jDouble % 2.0 - 0.5) / 4.0) / (double)nHalf);
                    initialCoords.set(a, 1, ((double)(j - nHalf) + (iDouble % 2.0 - 0.5) / 4.0) / (double)nHalf);
                    ++a;
                    ++j;
                }
                ++i;
            }
            Matrix dist = new Matrix(numCoords, 1);
            int i2 = 0;
            while (i2 < numCoords) {
                dist.set(i2, 0, Math.sqrt(Math.pow(initialCoords.get(i2, 0), 2.0) + Math.pow(initialCoords.get(i2, 1), 2.0)));
                ++i2;
            }
            Matrix tmpCoords = new Matrix(numCoords, 3);
            tmpCoords.setSubMatrix(0, 1, initialCoords);
            int numGoodCoords = 0;
            int i3 = 0;
            while (i3 < numCoords) {
                if (dist.get(i3, 0) < 1.0 - 1.0 / Math.sqrt(ndesired)) {
                    ++numGoodCoords;
                    tmpCoords.set(i3, 0, 1.0);
                } else {
                    tmpCoords.set(i3, 0, 0.0);
                }
                ++i3;
            }
            if (numGoodCoords > ndesired) {
                this.gridCoords = new Matrix(numGoodCoords, 2);
                int gridCoordsRow = 0;
                int i4 = 0;
                while (i4 < numCoords) {
                    if (tmpCoords.get(i4, 0) == 1.0) {
                        this.gridCoords.set(gridCoordsRow, 0, tmpCoords.get(i4, 1));
                        this.gridCoords.set(gridCoordsRow, 1, tmpCoords.get(i4, 2));
                        ++gridCoordsRow;
                    }
                    ++i4;
                }
                Matrix distList = new Matrix(numGoodCoords, 2);
                int i5 = 0;
                while (i5 < numGoodCoords) {
                    distList.set(i5, 0, i5);
                    distList.set(i5, 1, Math.sqrt(Math.pow(this.gridCoords.get(i5, 0), 2.0) + Math.pow(this.gridCoords.get(i5, 1), 2.0)));
                    ++i5;
                }
                Matrix indexDist = (Matrix)Sorting.MatrixRows(distList, 1);
                Matrix tmpGridCoords = (Matrix)this.gridCoords.copy();
                int i6 = 0;
                while (i6 < numGoodCoords) {
                    this.gridCoords.set(i6, 0, tmpGridCoords.get((int)indexDist.get(i6, 0), 0));
                    this.gridCoords.set(i6, 1, tmpGridCoords.get((int)indexDist.get(i6, 0), 1));
                    ++i6;
                }
                break;
            }
            ++loopCounter;
            ++n;
        }
        this.n_dots = n;
    }

    public void setMaxNumDots(int num) {
        this.maxNumDots = num;
        this.setNewDotGrid();
    }

    public void setNumber(int numDots) {
        this.numberDots = numDots;
        this.setDotPositions();
    }

    @Override
    public void update() {
        this.setRendered(false);
        this.dotContainer.update();
    }

    public void reset() {
        this.setActive(false);
        this.dotsFade = false;
        this.fadeAlpha = 1.0f;
        this.drawDotstoDotArray = true;
        int i = 0;
        while (i < this.maxNumDots) {
            this.dotList[i].reset();
            ++i;
        }
        this.update();
    }

    public void themeChanged() {
        if (this.dotList != null) {
            int i = 0;
            while (i < this.numberDots) {
                this.dotList[i].themeChanged();
                ++i;
            }
        }
        this.update();
    }

    public byte getId() {
        return this.id;
    }

    public double getConvertedMaxR() {
        return this.convertedMaxR;
    }

    public int getNumber() {
        return this.numberDots;
    }

    public void setDrawDotsToDotArray(boolean state) {
        this.drawDotstoDotArray = state;
    }

    public boolean getDrawDotsToDotArray() {
        return this.drawDotstoDotArray;
    }

    public void setDotsVisible(boolean state) {
        if (state) {
            int i = 0;
            while (i < this.numberDots) {
                this.dotList[i].setVisible(true);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.maxNumDots) {
                this.dotList[i].setVisible(false);
                ++i;
            }
        }
        this.dotsVisible = state;
        this.update();
    }

    public boolean getDotsVisible() {
        return this.dotsVisible;
    }

    public void setDotsFade(boolean state) {
        this.dotsFade = state;
        if (!state) {
            this.fadeAlpha = 1.0f;
        }
        this.update();
    }

    public boolean getDotsFade() {
        return this.dotsFade;
    }

    public void setFadeTime(int fadeTime) {
        this.fadeTime = fadeTime;
    }

    public void setFixedDensity(boolean state) {
        this.fixedDensity = state;
    }

    public void setFixedItemSize(boolean state) {
        this.fixedItemSize = state;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setX(int xPos) {
        this.x = xPos;
    }

    public void setY(int yPos) {
        this.y = yPos;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public void setPosition(float x, float y) {
    }

    @Override
    public void setVelocity(float x, float y) {
    }
}

