/*
 * Decompiled with CFR 0.152.
 */
package graphics.managers;

import algorithms.GameTurn;
import algorithms.Matrix3D;
import algorithms.NotnDimLevel;
import algorithms.NumCompAlgManager;
import data.Student;
import graphics.Game;
import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.PlayerPiece;
import graphics.vars.GraphicsVariables;
import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Random;
import org.jmat.data.Matrix;
import util.Utilities;

public class NumCompManager
extends AnimatedObject {
    private Game game;
    private ChoiceScreen choiceScreen;
    private BoardScreen boardScreen;
    private boolean stimsDisplayed = false;
    private boolean turnBeginning = false;
    private boolean gameBeginning = true;
    private int numGamesWon = 0;
    private int numGamesFinished = 0;
    private int currentTurnNumber = 0;
    private int currentGameNumber = 0;
    private GameTurn nextTurn;
    private GameTurn currentTurn;
    public static final byte NO_RESPONSE_ACCEPTED = 0;
    public static final byte NUM_COMP_RESPONSE = 1;
    public static final byte PLAYER1_CLICK_RESPONSE = 2;
    public static final byte PLAYER2_CLICK_RESPONSE = 3;
    public static final byte RETURN_TO_CHOICE_RESPONSE = 4;
    private Random randomNumber;
    private NumCompAlgManager numCompAlgManager;
    public boolean responseMade = false;
    private Point mousePoint = new Point(0, 0);
    public boolean responseHandled = false;
    private long systemTimeStamp;
    private int dotsLeftToClick = 0;
    private int dotsAlreadyClicked = 0;
    private int offScreenDots = 0;

    public NumCompManager(Game game, ChoiceScreen choiceScreen, BoardScreen boardScreen) {
        this.setActive(false);
        this.game = game;
        this.choiceScreen = choiceScreen;
        this.boardScreen = boardScreen;
    }

    @Override
    public void load() {
        if (!this.isReady()) {
            this.randomNumber = new Random();
            this.randomNumber.setSeed(System.currentTimeMillis());
            this.setReady(true);
        }
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            this.turnBeginning = true;
            return true;
        }
        return false;
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive()) {
            double elapsedTime;
            if (this.gameBeginning) {
                this.gameBeginning = false;
                this.runGameBeginningEvents();
            }
            if (this.turnBeginning && this.game.currentScreen == this.choiceScreen) {
                this.turnBeginning = false;
                this.runTurnBeginningEvents();
            }
            if (this.currentTurn.isDeadlineTrial() && this.isActive() && this.stimsDisplayed && !this.responseHandled && (elapsedTime = (double)(System.currentTimeMillis() - this.systemTimeStamp)) > this.currentTurn.getCurrentDeadline() + 1200.0) {
                this.setActive(false);
                this.choiceScreen.responseMode = 0;
                this.missedDeadline();
            }
        }
    }

    public void runGameBeginningEvents() {
        this.resetGame();
    }

    public void runTurnBeginningEvents() {
        ++this.currentTurnNumber;
        if (this.nextTurn == null) {
            this.currentTurn = new GameTurn(this.currentTurnNumber, this.boardScreen, this.game);
            this.initialiseTurn(this.currentTurn);
        } else {
            this.currentTurn = this.nextTurn;
            this.nextTurn = null;
        }
        this.currentTurn.startTurn();
        this.setStimsForTurn();
        this.choiceScreen.dotManagers[0].switchDrawingScreen("NOWHERE");
        this.choiceScreen.dotManagers[1].switchDrawingScreen("NOWHERE");
        this.showContainers();
        this.game.delay(2000, "ncm.runTurn()");
    }

    private void setStimsForTurn() {
        if (this.currentTurn.getControlDensity()) {
            this.choiceScreen.dotContainers[0].setFixedDensity(true);
            this.choiceScreen.dotContainers[0].setFixedItemSize(false);
            this.choiceScreen.dotContainers[1].setFixedDensity(true);
            this.choiceScreen.dotContainers[1].setFixedItemSize(false);
        } else {
            this.choiceScreen.dotContainers[0].setFixedDensity(false);
            this.choiceScreen.dotContainers[0].setFixedItemSize(true);
            this.choiceScreen.dotContainers[1].setFixedDensity(false);
            this.choiceScreen.dotContainers[1].setFixedItemSize(true);
        }
        this.choiceScreen.dotContainers[0].mainDotArray.setNumber(this.currentTurn.getNumber(0));
        this.choiceScreen.dotContainers[1].mainDotArray.setNumber(this.currentTurn.getNumber(1));
        NotnDimLevel notnLevel = this.numCompAlgManager.getNotnLevel(this.currentTurn.getCurrentNotnLevel());
        if (!notnLevel.addition && !notnLevel.subtraction) {
            this.choiceScreen.dotContainers[0].mainDotArray.setDotsVisible(notnLevel.analogMagStims);
            this.choiceScreen.dotContainers[1].mainDotArray.setDotsVisible(notnLevel.analogMagStims);
        }
        this.choiceScreen.dotContainers[0].setVerbalStims(notnLevel.verbalStims);
        this.choiceScreen.dotContainers[1].setVerbalStims(notnLevel.verbalStims);
        this.choiceScreen.dotContainers[0].mainDotArray.setDotsFade(notnLevel.dotsFade);
        this.choiceScreen.dotContainers[1].mainDotArray.setDotsFade(notnLevel.dotsFade);
        this.choiceScreen.dotContainers[0].mainDotArray.setFadeTime(notnLevel.fadeTime);
        this.choiceScreen.dotContainers[1].mainDotArray.setFadeTime(notnLevel.fadeTime);
        if (notnLevel.addition || notnLevel.subtraction) {
            int additionSide = this.currentTurn.getAdditionSide();
            if (notnLevel.addition) {
                this.choiceScreen.dotContainers[additionSide].setAddition(true);
                this.choiceScreen.dotContainers[additionSide].subDotArrays[0].setNumber(this.currentTurn.getSubNumber(additionSide, 0));
                this.choiceScreen.dotContainers[additionSide].subDotArrays[1].setNumber(this.currentTurn.getSubNumber(additionSide, 1));
                this.choiceScreen.dotContainers[additionSide].mainDotArray.setDotsVisible(false);
                this.choiceScreen.dotContainers[additionSide].subDotArrays[0].setDotsVisible(notnLevel.analogMagStims);
                this.choiceScreen.dotContainers[additionSide].subDotArrays[1].setDotsVisible(notnLevel.analogMagStims);
            }
            if (notnLevel.subtraction) {
                int subtractionSide = Utilities.oppositeSide(additionSide);
                this.choiceScreen.dotContainers[subtractionSide].setSubtraction(true);
                this.choiceScreen.dotContainers[subtractionSide].mainDotArray.setNumber(this.currentTurn.getSubNumber(subtractionSide, 0));
                this.choiceScreen.dotContainers[subtractionSide].mainDotArray.setDotsVisible(notnLevel.analogMagStims);
                this.choiceScreen.dotContainers[subtractionSide].subDotArrays[0].setDotsVisible(false);
                this.choiceScreen.dotContainers[subtractionSide].subDotArrays[1].setDotsVisible(false);
            }
        }
        this.choiceScreen.dotContainers[0].setArabicDigit(this.currentTurn);
        this.choiceScreen.dotContainers[1].setArabicDigit(this.currentTurn);
    }

    private void setHazardsForTurn(GameTurn turn) {
        NotnDimLevel notnLevel = this.numCompAlgManager.getNotnLevel(turn.getCurrentNotnLevel());
        if (turn.getTurnNumber() > 1) {
            this.boardScreen.hazardManager.setHazardLevel(notnLevel.hazards);
            this.boardScreen.hazardManager.setHazards(notnLevel.rangeRestriction);
        } else {
            this.boardScreen.hazardManager.setHazardLevel(false);
        }
    }

    public void runTurn() {
        this.game.setMousePosition(GraphicsVariables.BETWEEN_DOT_CONTAINERS.x, GraphicsVariables.BETWEEN_DOT_CONTAINERS.y);
        this.systemTimeStamp = System.currentTimeMillis();
        this.stimsDisplayed = true;
        this.showLeftStims();
        this.game.delay(1200, "ncm.showRightStims()");
        this.game.delay(1200, "ncm.setSneakInAction(1)");
    }

    public void initialiseTurn(GameTurn turnToSet) {
        this.numCompAlgManager.setStimAttributes(turnToSet);
    }

    public void showContainers() {
        this.choiceScreen.dotContainers[0].setVisible(true);
        this.choiceScreen.dotContainers[1].setVisible(true);
        if (!this.currentTurn.isDeadlineTrial()) {
            this.game.soundManager.play("chooseSide");
        } else {
            this.game.soundManager.play("chooseQuickly");
        }
    }

    public void showLeftStims() {
        if (this.numCompAlgManager.getNotnLevel((int)this.currentTurn.getCurrentNotnLevel()).analogMagStims) {
            this.choiceScreen.dotContainers[0].openContainer();
        }
        if (this.numCompAlgManager.getNotnLevel((int)this.currentTurn.getCurrentNotnLevel()).arabicStims) {
            this.choiceScreen.dotContainers[0].setArabicStims(true);
        }
        this.choiceScreen.dotContainers[0].setActive(true);
        this.choiceScreen.dotContainers[0].mainDotArray.setActive(true);
        if (this.numCompAlgManager.getNotnLevel((int)this.currentTurn.getCurrentNotnLevel()).verbalStims) {
            this.choiceScreen.dotContainers[0].playVerbalStims(0);
        }
    }

    public void showRightStims() {
        if (this.numCompAlgManager.getNotnLevel((int)this.currentTurn.getCurrentNotnLevel()).analogMagStims) {
            this.choiceScreen.dotContainers[1].openContainer();
        }
        if (this.numCompAlgManager.getNotnLevel((int)this.currentTurn.getCurrentNotnLevel()).arabicStims) {
            this.choiceScreen.dotContainers[1].setArabicStims(true);
        }
        this.choiceScreen.dotContainers[1].setActive(true);
        this.choiceScreen.dotContainers[1].mainDotArray.setActive(true);
        if (this.numCompAlgManager.getNotnLevel((int)this.currentTurn.getCurrentNotnLevel()).verbalStims) {
            this.choiceScreen.dotContainers[1].playVerbalStims(0);
        }
        this.choiceScreen.responseMode = 1;
    }

    public void setSneakInAction(int player) {
        if (this.currentTurn.isDeadlineTrial()) {
            this.choiceScreen.playerIcons[player].startSneaking((int)this.currentTurn.getCurrentDeadline());
        }
    }

    public boolean resetTurn() {
        this.choiceScreen.resetTurn();
        this.responseMade = false;
        this.responseHandled = false;
        this.stimsDisplayed = false;
        this.offScreenDots = 0;
        this.dotsLeftToClick = 0;
        this.dotsAlreadyClicked = 0;
        this.choiceScreen.rendered = false;
        this.choiceScreen.repaint();
        return true;
    }

    public boolean resetGame() {
        this.resetTurn();
        this.currentTurnNumber = 0;
        ++this.currentGameNumber;
        this.boardScreen.players[0].resetGame();
        this.boardScreen.players[1].resetGame();
        this.update();
        return true;
    }

    public void responseScript(boolean player1response, int playerMostDots, int player1sideSelected, int sideMostDots) {
        int playerLeastDots = Utilities.oppositeSide(playerMostDots);
        int sideLeastDots = Utilities.oppositeSide(sideMostDots);
        int player2sideSelected = Utilities.oppositeSide(player1sideSelected);
        if (player1response) {
            this.game.addTaskToQueue(0, "ncm.playerGetsArray(0," + player1sideSelected + "," + player1response + ")");
            this.game.addTaskToQueue(0, "ncm.lineUpDotsOnCarpet(0," + player1sideSelected + ")");
            this.game.addTaskToQueue(0, "ncm.playerGetsArray(1," + player2sideSelected + "," + player1response + ")");
            this.game.addTaskToQueue(0, "ncm.lineUpDotsOnCarpet(1," + player2sideSelected + ")");
        } else {
            this.game.addTaskToQueue(0, "ncm.playerGetsArray(1," + player2sideSelected + "," + player1response + ")");
            this.game.addTaskToQueue(0, "ncm.lineUpDotsOnCarpet(1," + player2sideSelected + ")");
            this.game.addTaskToQueue(0, "ncm.playerGetsArray(0," + player1sideSelected + "," + player1response + ")");
            this.game.addTaskToQueue(0, "ncm.lineUpDotsOnCarpet(0," + player1sideSelected + ")");
        }
        this.game.addTaskToQueue(0, "ncm.reactToPlayerGetsArray(0," + player1sideSelected + ")");
        this.game.addTaskToQueue(0, "ncm.reactToPlayerGetsArray(1," + player2sideSelected + ")");
        this.game.addTaskToQueue(0, "ncm.switchToBoardScreen()");
        this.game.addTaskToQueue(0, "ncm.collectClickResponse(0," + player1sideSelected + "," + player2sideSelected + ")");
        this.game.addTaskToQueue(0, "ncm.movePlayingPeice(0)");
        this.game.addTaskToQueue(0, "ncm.moveOver(0)");
        this.game.addTaskToQueue(0, "ncm.collectClickResponse(1," + player2sideSelected + "," + player1sideSelected + ")");
        this.game.addTaskToQueue(0, "ncm.movePlayingPeice(1)");
        this.game.addTaskToQueue(0, "ncm.moveOver(1)");
        this.game.addTaskToQueue(0, "ncm.reactToBoardMoves()");
        this.game.addTaskToQueue(0, "ncm.runTurnEndEvents()");
        this.game.nextTaskInQueue("ncm.responseScript");
    }

    public void playerGetsArray(int player, int sideSelected, boolean player1response) {
        this.choiceScreen.dotManagers[player].assignDotManager(this.choiceScreen.dotContainers[sideSelected], this.currentTurn);
        this.choiceScreen.dotContainers[sideSelected].select();
        if (player == 0) {
            this.choiceScreen.playerIcons[1].stopSneaking();
            if (player1response) {
                this.game.soundManager.play("friend1_youChose");
            } else {
                this.game.soundManager.play("friend1_andYouGet");
            }
        } else if (player == 1) {
            if (player1response) {
                this.game.soundManager.play("enemy1_andITake");
            } else {
                this.game.soundManager.play("enemy1_iTake");
            }
        }
        this.game.delay(1500, "game.choiceScreen.dotContainers[" + sideSelected + "].playVerbalStims(" + player + ")");
        this.game.delay(1500, "choiceScreen.dotContainers[" + sideSelected + "].setArabicStims(true)");
        if (this.choiceScreen.dotContainers[sideSelected].getAddition()) {
            this.game.delay(3000, "game.choiceScreen.dotContainers[" + sideSelected + "].showSum()");
            this.game.delay(5000, "game.nextTaskInQueue(\"ncm.playerGetsArray\")");
        } else if (this.choiceScreen.dotContainers[sideSelected].getSubtraction()) {
            this.game.choiceScreen.dotManagers[player].grabAndSubtractDots();
            this.game.delay(4000, "choiceScreen.dotManagers[" + player + "].start()");
            this.game.delay(4000, "game.choiceScreen.dotContainers[" + sideSelected + "].showSum()");
        } else {
            this.game.delay(1700, "game.nextTaskInQueue(\"ncm.playerGetsArray\")");
        }
    }

    public void lineUpDotsOnCarpet(int player, int sideSelected) {
        this.choiceScreen.dotManagers[player].grabAndLineUpDotsOnCarpet();
        this.game.delay(0, "choiceScreen.dotManagers[" + player + "].start()");
    }

    public void reactToPlayerGetsArray(int player, int sideSelected) {
        int[] numbers = this.currentTurn.getNumbers();
        if (player == 0) {
            if (numbers[sideSelected] < numbers[Utilities.oppositeSide((byte)sideSelected)]) {
                this.game.soundManager.play("friend1_youHaveLess");
                this.game.delay(700, "game.soundManager.play(\"wrong1\")");
            } else if (numbers[sideSelected] > numbers[Utilities.oppositeSide((byte)sideSelected)]) {
                this.game.soundManager.play("friend1_youHaveMore");
                this.choiceScreen.playerIcons[player].speak(950);
                this.game.delay(1000, "game.soundManager.play(\"cheer\")");
            }
            this.game.delay(3000, "game.nextTaskInQueue(\"ncm.reactToPlayerGetsArray\")");
        } else if (player == 1) {
            if (numbers[sideSelected] < numbers[Utilities.oppositeSide((byte)sideSelected)]) {
                this.game.soundManager.play("enemy1_iHaveTheLeast");
                this.choiceScreen.playerIcons[player].speak(1644);
            } else if (numbers[sideSelected] > numbers[Utilities.oppositeSide((byte)sideSelected)]) {
                this.game.soundManager.play("enemy1_iHaveTheMost");
            }
            this.game.delay(3000, "game.nextTaskInQueue(\"ncm.reactToPlayerGetsArray\")");
        }
    }

    public void switchToBoardScreen() {
        if (this.game.currentScreen != this.boardScreen) {
            this.game.changeCurrentScreenNoUnload(this.boardScreen);
            this.game.delay(100, "choiceScreen.dotManagers[0].updateDotList()");
            this.game.delay(100, "choiceScreen.dotManagers[1].updateDotList()");
        }
        this.choiceScreen.playerIcons[1].reset();
        this.game.soundManager.play("enemy1_wellSee");
        this.game.delay(2000, "game.nextTaskInQueue(\"ncm.switchToBoardScreen\")");
    }

    public void collectClickResponse(int player, int sideSelected, int oppositeSide) {
        if (player == 0) {
            this.boardScreen.responseMode = (byte)2;
            this.game.soundManager.play("moveYourCharacter");
        }
        if (player == 1) {
            this.boardScreen.responseMode = (byte)3;
            this.game.soundManager.play("enemy1_moveMeForward");
        }
        int[] numbers = this.currentTurn.getNumbers();
        this.boardScreen.players[player].setSquaresToMove(numbers[sideSelected]);
        this.dotsLeftToClick = Math.min(numbers[sideSelected], 40 - this.boardScreen.players[player].getBoardSquare());
        this.dotsAlreadyClicked = 0;
        if (numbers[sideSelected] > 40 - this.boardScreen.players[player].getBoardSquare()) {
            this.offScreenDots = numbers[sideSelected] - (40 - this.boardScreen.players[player].getBoardSquare());
        }
        this.choiceScreen.dotManagers[player].setupClickDotsToBoard();
    }

    public void movePlayingPeice(int player) {
        this.boardScreen.players[player].autoMoveSquares();
        this.boardScreen.players[player].start();
    }

    public void moveOver(int player) {
        this.choiceScreen.dotManagers[player].setDotsVisible(false);
        this.game.delay(0, "game.nextTaskInQueue(\"ncm.moveOver\")");
    }

    public void reactToBoardMoves() {
        this.currentTurn.setPostTurnInterPlayerDistance(this.boardScreen.players[0].getBoardSquare() - this.boardScreen.players[1].getBoardSquare());
        int changeInDistance = this.currentTurn.getPostTurnInterPlayerDistance() - this.currentTurn.getPreTurnInterPlayerDistance();
        if (this.currentTurn.getPreTurnInterPlayerDistance() < 0) {
            if (this.currentTurn.getPostTurnInterPlayerDistance() > 0) {
                this.game.soundManager.play("enemy1_youveOvertakenMe");
                this.boardScreen.players[1].speak(2400);
                this.game.delay(3000, "game.soundManager.play(\"right\")");
            } else if (changeInDistance < 0) {
                this.game.soundManager.play("enemy1_tryToCatchMe");
                this.game.delay(3000, "game.soundManager.play(\"wrong2\")");
            } else if (changeInDistance > 0) {
                this.game.soundManager.play("enemy1_youreCatchingUp");
                this.boardScreen.players[1].speak(2980);
                this.game.delay(3000, "game.soundManager.play(\"right\")");
            } else {
                this.game.soundManager.play("enemy1_imStillAhead");
                this.game.delay(3000, "game.soundManager.play(\"wrong2\")");
            }
        } else if (this.currentTurn.getPreTurnInterPlayerDistance() > 0) {
            if (this.currentTurn.getPostTurnInterPlayerDistance() < 0) {
                this.game.soundManager.play("enemy1_iveOvertakenYou");
                this.game.delay(3000, "game.soundManager.play(\"wrong2\")");
            } else if (changeInDistance < 0) {
                this.game.soundManager.play("enemy1_imCatchingUp");
                this.game.delay(3000, "game.soundManager.play(\"wrong2\")");
            } else if (changeInDistance > 0) {
                if (this.currentTurn.getPostTurnInterPlayerDistance() >= 10) {
                    this.game.soundManager.play("enemy1_imMilesBehind");
                    this.boardScreen.players[1].speak(3300);
                    this.game.delay(3000, "game.soundManager.play(\"right\")");
                } else if (this.currentTurn.getPostTurnInterPlayerDistance() >= 5) {
                    this.game.soundManager.play("enemy1_gettingBehind");
                    this.boardScreen.players[1].speak(2900);
                    this.game.delay(3000, "game.soundManager.play(\"right\")");
                } else {
                    this.game.soundManager.play("enemy1_justBehind");
                    this.boardScreen.players[1].speak(1600);
                    this.game.delay(2000, "game.soundManager.play(\"right\")");
                }
            } else {
                this.game.soundManager.play("enemy1_youreStillAhead");
                this.game.delay(3000, "game.soundManager.play(\"right\")");
            }
        } else if (this.currentTurn.getPostTurnInterPlayerDistance() < 0) {
            this.game.soundManager.play("enemy1_imAhead");
            this.game.delay(3000, "game.soundManager.play(\"wrong2\")");
        } else {
            this.game.soundManager.play("enemy1_youWentTheFurtherest");
            this.boardScreen.players[1].speak(3360);
            this.game.delay(3000, "game.soundManager.play(\"right\")");
        }
        this.game.delay(6000, "game.nextTaskInQueue(\"ncm.reactToBoardMoves\")");
    }

    public void runTurnEndEvents() {
        this.nextTurn = new GameTurn(this.currentTurnNumber + 1, this.boardScreen, this.game);
        this.initialiseTurn(this.nextTurn);
        this.setHazardsForTurn(this.nextTurn);
        this.game.delay(5000, "game.soundManager.play(\"toContinue\")");
        this.resetTurn();
    }

    public void missedDeadline() {
        this.responseHandled = true;
        this.game.soundManager.play("enemy1_iTookTheMost");
        Matrix responsePoint = new Matrix(1, 4);
        int[] numbers = this.currentTurn.getNumbers();
        if (numbers[0] < numbers[1]) {
            this.currentTurn.setResponseSide((byte)0);
            this.currentTurn.calculateActualWinner();
            this.currentTurn.setResponseCorrect((byte)0);
            this.currentTurn.setActualWinner((byte)1);
            this.game.dataFileHandler.writeStudentFileDataLine(this.currentTurn);
            responsePoint.setSubMatrix(0, 0, this.currentTurn.getCurrentDifficulty());
            responsePoint.set(0, 3, 0.0);
            boolean successfullyAddedTrial = this.numCompAlgManager.addTrial(responsePoint);
            this.game.delay(3200, "ncm.responseScript(false,util.Constants.PLAYER2,util.Constants.LEFT,util.Constants.RIGHT)");
        } else if (numbers[0] > numbers[1]) {
            this.currentTurn.setResponseSide((byte)1);
            this.currentTurn.calculateActualWinner();
            this.currentTurn.setResponseCorrect((byte)0);
            this.currentTurn.setActualWinner((byte)1);
            this.game.dataFileHandler.writeStudentFileDataLine(this.currentTurn);
            responsePoint.setSubMatrix(0, 0, this.currentTurn.getCurrentDifficulty());
            responsePoint.set(0, 3, 0.0);
            boolean successfullyAddedTrial = this.numCompAlgManager.addTrial(responsePoint);
            this.game.delay(3200, "ncm.responseScript(false,util.Constants.PLAYER2,util.Constants.RIGHT,util.Constants.LEFT)");
        }
    }

    public void responseHandler(AWTEvent e) {
        this.mousePoint.setLocation(((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        if (this.game.currentScreen == this.choiceScreen && this.choiceScreen.responseMode == 1) {
            long RT = System.currentTimeMillis() - this.systemTimeStamp;
            this.responseHandled = true;
            this.currentTurn.setRT(RT);
            int[] numbers = this.currentTurn.getNumbers();
            if (this.choiceScreen.dotContainers[0].isPointInBounds(this.mousePoint)) {
                this.choiceScreen.responseMode = 0;
                this.responseMade = true;
                this.currentTurn.setResponseSide((byte)0);
                if (numbers[0] < numbers[1]) {
                    this.currentTurn.setResponseCorrect((byte)0);
                    this.responseScript(true, 1, 0, 1);
                } else if (numbers[0] > numbers[1]) {
                    this.currentTurn.setResponseCorrect((byte)1);
                    this.responseScript(true, 0, 0, 0);
                }
            } else if (this.choiceScreen.dotContainers[1].isPointInBounds(this.mousePoint)) {
                this.choiceScreen.responseMode = 0;
                this.responseMade = true;
                this.currentTurn.setResponseSide((byte)1);
                if (numbers[0] > numbers[1]) {
                    this.currentTurn.setResponseCorrect((byte)0);
                    this.responseScript(true, 1, 1, 0);
                } else if (numbers[0] < numbers[1]) {
                    this.currentTurn.setResponseCorrect((byte)1);
                    this.responseScript(true, 0, 1, 1);
                }
            }
            if (this.responseMade) {
                this.currentTurn.calculateActualWinner();
                this.game.dataFileHandler.writeStudentFileDataLine(this.currentTurn);
                Matrix responsePoint = new Matrix(1, 4);
                responsePoint.setSubMatrix(0, 0, this.currentTurn.getCurrentDifficulty());
                responsePoint.set(0, 3, this.currentTurn.getFinalCorrect());
                boolean bl = this.numCompAlgManager.addTrial(responsePoint);
            }
        }
        if (this.game.currentScreen == this.boardScreen && (this.boardScreen.responseMode == 2 && !this.choiceScreen.dotManagers[0].isActive() || this.boardScreen.responseMode == 3 && !this.choiceScreen.dotManagers[1].isActive()) && this.boardScreen.numberBoard.wasSquareClickedOnBoard(this.mousePoint)) {
            int squareDistance;
            int squareResponse = this.boardScreen.numberBoard.getSquareClickedOnBoard();
            int[] numbers = this.currentTurn.getNumbers();
            if (this.boardScreen.responseMode == 2) {
                int squareDistance2 = squareResponse - this.boardScreen.players[0].getBoardSquare();
                if (squareDistance2 <= numbers[this.currentTurn.getResponseSide()] - this.offScreenDots && squareDistance2 > 0) {
                    this.game.soundManager.stopAllSounds();
                    this.game.removeTasksFromList("soundManager");
                    this.dotsLeftToClick -= squareDistance2 - this.dotsAlreadyClicked;
                    this.choiceScreen.dotManagers[0].nextClickResponse((byte)0, squareDistance2 - this.dotsAlreadyClicked);
                    this.dotsAlreadyClicked = squareDistance2;
                    if (this.dotsLeftToClick == 0) {
                        this.boardScreen.responseMode = 0;
                    }
                }
            } else if (this.boardScreen.responseMode == 3 && (squareDistance = squareResponse - this.boardScreen.players[1].getBoardSquare()) <= numbers[Utilities.oppositeSide(this.currentTurn.getResponseSide())] - this.offScreenDots && squareDistance > 0) {
                this.game.soundManager.stopAllSounds();
                this.game.removeTasksFromList("soundManager");
                this.dotsLeftToClick -= squareDistance - this.dotsAlreadyClicked;
                this.choiceScreen.dotManagers[1].nextClickResponse((byte)1, squareDistance - this.dotsAlreadyClicked);
                this.dotsAlreadyClicked = squareDistance;
                if (this.dotsLeftToClick == 0) {
                    this.boardScreen.responseMode = 0;
                }
            }
        }
    }

    public void playerWins(PlayerPiece player) {
        this.game.taskManager.clearTaskList();
        this.game.taskManager.clearTaskQueue();
        this.game.currentStudent.augmentGamesPlayed();
        if (player.playerID == 0) {
            this.game.soundManager.play("cheer");
            this.game.delay(1800, "game.soundManager.play(\"right\")");
            this.game.gameOverScreen.lastWinner = 0;
            ++this.numGamesWon;
            this.game.currentStudent.augmentGamesWon();
        } else if (player.playerID == 1) {
            this.game.soundManager.play("wrong2");
            this.game.gameOverScreen.lastWinner = 1;
        }
        ++this.numGamesFinished;
        this.setActive(false);
        this.gameBeginning = true;
        this.game.delay(1000, "game.changeCurrentScreenNoUnload(game.gameOverScreen)");
    }

    public void endGame() {
        this.game.taskManager.clearTaskList();
        this.game.taskManager.clearTaskQueue();
        this.setActive(false);
        this.gameBeginning = true;
        this.game.delay(1000, "game.changeCurrentScreen(game.regScreen)");
    }

    public int getNumGamesWon() {
        return this.numGamesWon;
    }

    public int getNumGamesPlayed() {
        return this.numGamesFinished;
    }

    public boolean getGameBeginning() {
        return this.gameBeginning;
    }

    public GameTurn getCurrentTurn() {
        return this.currentTurn;
    }

    public void newStudent(Student student) {
        this.numCompAlgManager = new NumCompAlgManager(this.game, student);
    }

    public void exitStudent() {
        this.nextTurn = null;
        this.numCompAlgManager = null;
    }

    public String getNotnAttrCommaDelim(int currentNotnLevel) {
        return this.numCompAlgManager.getNotnAttrCommaDelim(currentNotnLevel);
    }

    public void setModelData(Matrix modelData, Matrix3D edMatrix) {
        this.numCompAlgManager.setModelData(modelData, edMatrix);
    }

    @Override
    public void paint(Graphics2D g2D) {
    }

    @Override
    public void update() {
    }

    @Override
    public void setPosition(float x, float y) {
    }

    @Override
    public void setVelocity(float x, float y) {
    }
}

