/*
 * Decompiled with CFR 0.152.
 */
package graphics.events;

import bsh.EvalError;
import graphics.events.TaskManager;

public class Task
implements Runnable {
    private long startTime;
    private long cumPauseTime;
    private long pauseStartStamp;
    private double delay;
    private boolean checkDelay;
    String statement;
    private boolean done;
    private TaskManager taskManager;

    public Task(TaskManager taskManager, boolean checkDelay, int delay, String statement, long startTime) {
        this.taskManager = taskManager;
        this.delay = delay;
        this.statement = statement;
        this.startTime = startTime;
        this.cumPauseTime = 0L;
        this.checkDelay = checkDelay;
    }

    public void cancel() {
        this.done = true;
    }

    public String toString() {
        return this.statement;
    }

    @Override
    public void run() {
        try {
            this.taskManager.bsh.eval(this.statement);
        }
        catch (EvalError e) {
            e.printStackTrace();
        }
    }

    public boolean check() {
        long currentTime = System.currentTimeMillis();
        if (!(this.done || this.checkDelay && !((double)(currentTime - this.startTime - this.cumPauseTime) >= this.delay))) {
            this.done = true;
            try {
                this.run();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.done;
    }

    public boolean containsKey(String key) {
        return this.statement.indexOf(key) != -1;
    }

    public boolean accountForPause(long pauseStartStamp, long pauseEndStamp) {
        this.cumPauseTime += pauseStartStamp - pauseEndStamp;
        return true;
    }
}

