/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import data.DataFileHandler;
import data.Student;
import debug.Debugger;
import debug.Simulator;
import graphics.events.TaskManager;
import graphics.screens.CharacChoiceScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.CopyrightScreen;
import graphics.screens.GameMenuScreen;
import graphics.screens.GameOverScreen;
import graphics.screens.InstrucScreen;
import graphics.screens.RegScreen;
import graphics.screens.RewardScreen;
import graphics.screens.RewardViewScreen;
import graphics.screens.Screen;
import graphics.screens.ThemeChoiceScreen;
import graphics.screens.TitleScreen;
import graphics.vars.ThemeVariables;
import java.awt.AWTException;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import sound.SoundManager;

public class Game
extends JFrame
implements FocusListener,
KeyListener,
Runnable {
    private static Game game;
    public Screen currentScreen;
    public Screen previousScreen;
    public Student currentStudent;
    public boolean gameRunning;
    public boolean gamePaused;
    private Calendar gameCalendar = Calendar.getInstance();
    public ChoiceScreen choiceScreen;
    public CopyrightScreen copyrightScreen;
    public TitleScreen titleScreen;
    public RegScreen regScreen;
    public InstrucScreen instrucScreen;
    public CharacChoiceScreen characChoiceScreen;
    public ThemeChoiceScreen themeChoiceScreen;
    public RewardScreen rewardScreen;
    public RewardViewScreen rewardViewScreen;
    public GameOverScreen gameOverScreen;
    public GameMenuScreen gameMenuScreen;
    public SoundManager soundManager;
    public TaskManager taskManager;
    public DataFileHandler dataFileHandler;
    private int mode;
    public GraphicsConfiguration gc;
    public GraphicsDevice gd;
    public ThemeVariables themeVars;
    private byte currentTheme;
    private Robot mouseController;
    private Thread loop;
    public static final int ANIMATION_SPEED = 40;
    static final int DELAYTIME = 25;
    public static long actualFrameRate;
    public Debugger debugger;
    long appStartTime = System.currentTimeMillis();
    public Simulator simulator;
    public static final byte NUM_PLAYERS = 2;
    private static final int FULLSCREEN_MODE = 0;
    private static final int WINDOWED_MODE = 1;
    private static final AudioFormat PLAYBACK_FORMAT;
    private static final int MANY_SOUNDS_COUNT;

    static {
        actualFrameRate = 0L;
        PLAYBACK_FORMAT = new AudioFormat(22050.0f, 16, 1, true, false);
        MANY_SOUNDS_COUNT = SoundManager.getMaxSimultaneousSounds(PLAYBACK_FORMAT);
    }

    public Game() {
        super("Gara dei Numeri");
        this.getContentPane().setLayout(null);
        this.setSize(1024, 768);
        this.setDefaultCloseOperation(3);
        this.setIgnoreRepaint(true);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.gd = ge.getDefaultScreenDevice();
        this.gc = this.gd.getDefaultConfiguration();
        try {
            this.mouseController = new Robot();
        }
        catch (AWTException e) {
            System.out.println(e.getStackTrace());
        }
        Rectangle bounds = this.getBounds();
        BufferedImage backBuffer = new BufferedImage(bounds.width, bounds.height, 1);
        this.themeVars = new ThemeVariables(0);
        this.choiceScreen = new ChoiceScreen(bounds, this, backBuffer);
        this.copyrightScreen = new CopyrightScreen(bounds, this, backBuffer);
        this.regScreen = new RegScreen(bounds, this, backBuffer);
        this.titleScreen = new TitleScreen(bounds, this, backBuffer);
        this.instrucScreen = new InstrucScreen(bounds, this, backBuffer);
        this.gameOverScreen = new GameOverScreen(bounds, this, backBuffer);
        this.characChoiceScreen = new CharacChoiceScreen(bounds, this, backBuffer);
        this.themeChoiceScreen = new ThemeChoiceScreen(bounds, this, backBuffer);
        this.rewardScreen = new RewardScreen(bounds, this, backBuffer);
        this.rewardViewScreen = new RewardViewScreen(bounds, this, backBuffer);
        this.gameMenuScreen = new GameMenuScreen(bounds, this, backBuffer);
        this.dataFileHandler = new DataFileHandler(this, this.choiceScreen.ncm);
        this.soundManager = new SoundManager(PLAYBACK_FORMAT, this);
        this.taskManager = new TaskManager(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Game.this.endGame();
            }
        });
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public static void main(String[] args) {
        game = new Game();
        game.initialize();
    }

    public void initialize() {
        Object[] options = new Object[]{"Schermo intero", "Finestra"};
        int choice = JOptionPane.showOptionDialog(null, "Seleziona il tipo di visualizzazione:", "Gara dei Numeri", -1, 3, null, options, options[0]);
        if (choice != -1) {
            this.setMode(choice);
            this.copyrightScreen.load();
            this.currentScreen = this.copyrightScreen;
            this.copyrightScreen.start();
        } else if (choice == -1) {
            this.endGame();
        }
        this.getContentPane().add(this.currentScreen);
        this.setVisible(true);
        this.resizeToInternalSize(1024, 768);
        this.setResizable(false);
        this.gameRunning = true;
        game.start();
    }

    public void start() {
        this.loop = new Thread((Runnable)this, "AnimationLoop");
        this.loop.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.gameRunning) {
            Thread thisThread = Thread.currentThread();
            while (this.loop == thisThread) {
                long startTime = System.currentTimeMillis();
                while (this.gamePaused && this.currentScreen != this.gameMenuScreen) {
                    Game game = this;
                    synchronized (game) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                this.taskManager.update();
                this.currentScreen.process();
                if (this.currentScreen.reRender()) {
                    this.currentScreen.repaint();
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                long waitTime = Math.max(25L - elapsedTime, 5L);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                actualFrameRate = 1000L / (System.currentTimeMillis() - startTime + 1L) + 1L;
            }
        }
        game.endGame();
    }

    public void changeCurrentScreen(Screen screen) {
        this.currentScreen.loading = true;
        screen.loading = true;
        this.previousScreen = this.currentScreen;
        this.currentScreen = screen;
        this.previousScreen.unload();
        if (!this.currentScreen.readyToProcess) {
            this.currentScreen.load();
        } else {
            this.currentScreen.loading = false;
        }
        while (this.currentScreen.loading) {
        }
        this.getContentPane().remove(this.previousScreen);
        this.getContentPane().add(this.currentScreen);
        this.currentScreen.start();
    }

    public void changeCurrentScreenNoUnload(Screen screen) {
        if (this.currentScreen != screen) {
            if (screen.readyToProcess) {
                this.previousScreen = this.currentScreen;
                this.currentScreen = screen;
                this.getContentPane().remove(this.previousScreen);
                this.getContentPane().add(this.currentScreen);
                this.currentScreen.start();
            } else {
                this.currentScreen.loading = true;
                screen.loading = true;
                this.previousScreen = this.currentScreen;
                this.currentScreen = screen;
                this.currentScreen.load();
                this.previousScreen.loading = false;
                while (this.currentScreen.loading) {
                }
                this.getContentPane().remove(this.previousScreen);
                this.getContentPane().add(this.currentScreen);
                this.currentScreen.start();
            }
        }
    }

    public void setTheme(byte theme) {
        if (theme == 1 || theme == 0) {
            this.currentTheme = theme;
            this.themeVars = new ThemeVariables(theme);
            this.choiceScreen.themeChanged();
            this.gameOverScreen.themeChanged();
            this.rewardViewScreen.themeChanged();
            this.characChoiceScreen.themeChanged();
            this.rewardScreen.themeChanged();
            this.instrucScreen.themeChanged();
        } else {
            System.out.println("Error: Theme does not exist!");
        }
    }

    public byte getTheme() {
        return this.currentTheme;
    }

    public void delay(int delay, String statement) {
        long startTime = System.currentTimeMillis();
        this.taskManager.addTaskToList(delay, statement, startTime);
    }

    public void addTaskToQueue(int delay, String statement) {
        long startTime = System.currentTimeMillis();
        this.taskManager.addTaskToQueue(delay, statement, startTime);
    }

    public void nextTaskInQueue(String calledBy) {
        String taskName = this.taskManager.nextInTaskQueue();
    }

    public void clearTaskQueue() {
        this.taskManager.clearTaskQueue();
    }

    public boolean removeTasksFromList(String key) {
        this.taskManager.removeTasksFromList(key);
        return true;
    }

    public void endGame() {
        boolean success1 = this.dataFileHandler.saveGame();
        boolean success2 = this.dataFileHandler.closeAllDataFiles();
        if (success1 && success2) {
            this.dispose();
            System.exit(0);
        }
    }

    public void pauseGame() {
        if (this.soundManager != null) {
            this.soundManager.setPaused(true);
        }
        if (this.taskManager != null) {
            this.taskManager.setPaused(true);
        }
        this.gamePaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpauseGame() {
        this.gamePaused = false;
        Game game = this;
        synchronized (game) {
            this.notify();
        }
        if (this.soundManager != null) {
            this.soundManager.setPaused(false);
        }
        if (this.taskManager != null) {
            this.taskManager.setPaused(false);
        }
    }

    public void callMenu(Screen originScreen) {
        this.gameMenuScreen.setOriginScreen(originScreen);
        this.changeCurrentScreenNoUnload(this.gameMenuScreen);
        game.pauseGame();
    }

    public void returnFromMenu() {
        Screen originScreen = this.gameMenuScreen.getOriginScreen();
        if (this.currentScreen != originScreen && originScreen.readyToProcess) {
            this.currentScreen = originScreen;
            this.getContentPane().remove(this.gameMenuScreen);
            this.getContentPane().add(originScreen);
            this.gameMenuScreen.unload();
            this.currentScreen.setRendered(false);
            this.unpauseGame();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.currentScreen != null && !this.currentScreen.isFocusOwner()) {
            this.pauseGame();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.currentScreen != null) {
            this.currentScreen.rendered = false;
            this.unpauseGame();
        }
    }

    public Date getDate() {
        this.gameCalendar.setTimeInMillis(System.currentTimeMillis());
        return this.gameCalendar.getTime();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.currentScreen.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setMousePosition(int x, int y) {
        if (this.mouseController != null) {
            this.mouseController.mouseMove(x, y);
        }
    }

    public void setMode(int mode) {
        if (mode == 0 && !this.gd.isFullScreenSupported()) {
            mode = 1;
            System.out.println("Sorry, fullscreen mode not supported, continuing in windowed mode");
        }
        this.mode = mode;
        try {
            if (mode == 0) {
                game.setUndecorated(true);
                this.gd.setFullScreenWindow(game);
                if (this.gd.isDisplayChangeSupported()) {
                    DisplayMode dm = new DisplayMode(1024, 768, 16, 0);
                    if (this.isDisplayModeAvailable(dm)) {
                        this.gd.setDisplayMode(dm);
                    } else {
                        System.out.println("Display mode not available: " + dm.getWidth() + ":" + dm.getHeight() + ":" + dm.getBitDepth());
                        System.exit(0);
                    }
                } else {
                    System.out.println("Display change not supported");
                    System.exit(0);
                }
            } else {
                game.setVisible(true);
            }
        }
        catch (Exception e) {
            this.gd.setFullScreenWindow(null);
            e.printStackTrace();
        }
    }

    public boolean isDisplayModeAvailable(DisplayMode dm) {
        DisplayMode[] availableModes = this.gd.getDisplayModes();
        int i = 0;
        while (i < availableModes.length) {
            if (dm.getWidth() == availableModes[i].getWidth() && dm.getHeight() == availableModes[i].getHeight() && dm.getBitDepth() == availableModes[i].getBitDepth()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void resizeToInternalSize(int internalWidth, int internalHeight) {
        Insets insets = this.getInsets();
        final int newWidth = internalWidth + insets.left + insets.right;
        final int newHeight = internalHeight + insets.top + insets.bottom;
        Runnable resize = new Runnable(){

            @Override
            public void run() {
                Game.this.setSize(newWidth, newHeight);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(resize);
            }
            catch (Exception exception) {}
        } else {
            resize.run();
        }
        this.validate();
    }
}

