/*
 * Decompiled with CFR 0.152.
 */
package data;

import graphics.screens.CharacChoiceScreen;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;

public class Student {
    private int dataLine;
    private String lastName;
    private String firstName;
    private int age;
    private String classLevel;
    private String sex;
    private int startLevel;
    private int sessionNumber;
    private String fileHeader;
    private boolean[][] characAccess;
    private byte[][] rewardCount;
    private int gamesPlayedSession;
    private int gamesWonSession;
    private int gamesPlayedTotal;
    private int gamesWonTotal;
    private Random randomNumber;
    public static final int NUM_GAMES_PER_CHARAC = 10;

    public Student(int dataLine, String lastName, String firstName, int age, String classLevel, String sex, int lastSessionNumber, int gamesWon, int gamesPlayed, boolean[][] characAccess, byte[][] rewardCount) {
        this.dataLine = dataLine;
        this.lastName = lastName;
        this.firstName = firstName;
        this.age = age;
        this.classLevel = classLevel;
        this.sex = sex;
        this.sessionNumber = lastSessionNumber;
        this.startLevel = 0;
        this.gamesWonTotal = gamesWon;
        this.gamesPlayedTotal = gamesPlayed;
        this.characAccess = characAccess;
        this.rewardCount = rewardCount;
        this.fileHeader = String.valueOf(lastName) + "_" + firstName;
        this.randomNumber = new Random(System.currentTimeMillis());
    }

    public Student(int dataLine, String lastName, String firstName, int age, String classLevel, String sex, int startLevel, int lastSessionNumber, int gamesWon, int gamesPlayed, boolean[][] characAccess, byte[][] rewardCount) {
        this.dataLine = dataLine;
        this.lastName = lastName;
        this.firstName = firstName;
        this.age = age;
        this.classLevel = classLevel;
        this.sex = sex;
        this.startLevel = startLevel < 1 | startLevel > 14 ? 0 : startLevel;
        this.sessionNumber = lastSessionNumber;
        this.gamesWonTotal = gamesWon;
        this.gamesPlayedTotal = gamesPlayed;
        this.characAccess = characAccess;
        this.rewardCount = rewardCount;
        this.fileHeader = String.valueOf(lastName) + "_" + firstName;
        this.randomNumber = new Random(System.currentTimeMillis());
    }

    public String toString() {
        return String.valueOf(this.lastName) + ", " + this.firstName;
    }

    public void augmentSession() {
        ++this.sessionNumber;
    }

    public void augmentGamesPlayed() {
        ++this.gamesPlayedSession;
        ++this.gamesPlayedTotal;
    }

    public void augmentGamesWon() {
        ++this.gamesWonSession;
        ++this.gamesWonTotal;
    }

    public static String getHeaders() {
        return "DataLine, LastName,FirstName,Age,ClassLevel,Sex,LastSession,gamesWon,gamesPlayedlev1char1,lev1char2,lev1char3,lev1char4,lev1char5,lev1char6lev2char1,lev2char2,lev2char3,lev2char4,lev2char5,lev2char6lev1rew1,lev1rew2,lev1rew3,lev1rew4,lev1rew5,lev1rew6,lev1rew7lev2rew1,lev2rew2,lev2rew3,lev2rew4,lev2rew5,lev2rew6,lev2rew7, startLevel";
    }

    public String getAttributesCommaDelim() {
        String commaDelimStr = String.valueOf(this.dataLine) + "," + this.lastName + "," + this.firstName + "," + this.age + "," + this.classLevel + "," + this.sex + "," + this.sessionNumber + "," + this.gamesWonTotal + "," + this.gamesPlayedTotal + "," + this.characAccess[0][0] + "," + this.characAccess[0][1] + "," + this.characAccess[0][2] + "," + this.characAccess[0][3] + "," + this.characAccess[0][4] + "," + this.characAccess[0][5] + "," + this.characAccess[1][0] + "," + this.characAccess[1][1] + "," + this.characAccess[1][2] + "," + this.characAccess[1][3] + "," + this.characAccess[1][4] + "," + this.characAccess[1][5] + "," + this.rewardCount[0][0] + "," + this.rewardCount[0][1] + "," + this.rewardCount[0][2] + "," + this.rewardCount[0][3] + "," + this.rewardCount[0][4] + "," + this.rewardCount[0][5] + "," + this.rewardCount[0][6] + "," + this.rewardCount[1][0] + "," + this.rewardCount[1][1] + "," + this.rewardCount[1][2] + "," + this.rewardCount[1][3] + "," + this.rewardCount[1][4] + "," + this.rewardCount[1][5] + "," + this.rewardCount[1][6] + "," + this.startLevel;
        return commaDelimStr;
    }

    public int getNumRewardsCollected(byte graphicalLevel) {
        int rewardTotal = 0;
        int i = 0;
        while (i < 7) {
            rewardTotal += this.rewardCount[graphicalLevel][i];
            ++i;
        }
        return rewardTotal;
    }

    public byte[] getRewardCount(byte graphicalLevel) {
        return this.rewardCount[graphicalLevel];
    }

    public void addReward(int rewardType, byte graphicalLevel) {
        byte[] byArray = this.rewardCount[graphicalLevel];
        int n = rewardType;
        byArray[n] = (byte)(byArray[n] + 1);
    }

    public int getNextRewardEasy(byte graphicalLevel) {
        int reward = 99;
        boolean invalidPick = true;
        int numLoops = 0;
        block0: while (invalidPick) {
            ++numLoops;
            reward = this.randomNumber.nextInt(7);
            if (this.rewardCount[graphicalLevel][reward] == 0) {
                invalidPick = false;
                continue;
            }
            if (numLoops < 14) continue;
            int i = 0;
            while (i < 7) {
                if (this.rewardCount[graphicalLevel][i] == 0) {
                    reward = i;
                    break block0;
                }
                ++i;
            }
        }
        return reward;
    }

    public int getNextReward(byte graphicalLevel) {
        int reward = 99;
        int numZeros = 0;
        int i = 0;
        while (i < 7) {
            if (this.rewardCount[graphicalLevel][i] == 0) {
                ++numZeros;
            }
            ++i;
        }
        int numGamesSinceLastUnlock = this.gamesPlayedTotal - this.getNumCharacsUnlocked(graphicalLevel) * 10;
        int numGamesBeforeNextUnlock = 10 - numGamesSinceLastUnlock;
        if (numZeros == numGamesBeforeNextUnlock) {
            int i2 = 0;
            while (i2 < 7) {
                if (this.rewardCount[graphicalLevel][i2] == 0) {
                    reward = i2;
                    break;
                }
                ++i2;
            }
        } else if (numZeros == 1) {
            reward = this.randomNumber.nextInt(7);
            int i3 = 0;
            while (i3 < 7) {
                if (this.rewardCount[graphicalLevel][i3] == 0) {
                    while (reward == i3) {
                        reward = this.randomNumber.nextInt(7);
                    }
                }
                ++i3;
            }
        } else {
            reward = this.randomNumber.nextInt(7);
        }
        return reward;
    }

    public boolean checkForCharacterUnlock(byte graphicalLevel) {
        boolean characterUnlocked = true;
        int i = 0;
        while (i < 7) {
            if (this.rewardCount[graphicalLevel][i] == 0) {
                characterUnlocked = false;
            }
            ++i;
        }
        return characterUnlocked;
    }

    public void unlockNextCharacter(CharacChoiceScreen characChoiceScreen, byte graphicalLevel) {
        int i = 0;
        while (i < 6) {
            if (!this.characAccess[graphicalLevel][i]) {
                this.characAccess[graphicalLevel][i] = true;
                int j = 0;
                while (j < 7) {
                    this.rewardCount[graphicalLevel][j] = 0;
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public static Student readAllStudentListLine(LineNumberReader studentTextFileLineReader) {
        String lineReadFromFile = null;
        Student student = null;
        if (studentTextFileLineReader != null) {
            int passes = 0;
            do {
                try {
                    lineReadFromFile = studentTextFileLineReader.readLine();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
                passes = (byte)(passes + 1);
            } while (studentTextFileLineReader.getLineNumber() == 1 && passes <= 1);
            if (lineReadFromFile != null) {
                StringTokenizer stringConvertor = new StringTokenizer(lineReadFromFile, ",");
                int dataLine = Integer.parseInt(stringConvertor.nextToken());
                String lastName = stringConvertor.nextToken();
                String firstName = stringConvertor.nextToken();
                String ageStr = stringConvertor.nextToken();
                int age = Integer.parseInt(ageStr);
                String classLevel = stringConvertor.nextToken();
                String sex = stringConvertor.nextToken();
                int sessionNumber = Integer.parseInt(stringConvertor.nextToken());
                int gamesWon = Integer.parseInt(stringConvertor.nextToken());
                int gamesTotal = Integer.parseInt(stringConvertor.nextToken());
                boolean[][] characAccess = new boolean[2][6];
                int j = 0;
                while (j < 2) {
                    int i = 0;
                    while (i < 6) {
                        String tmpStr = stringConvertor.nextToken();
                        characAccess[j][i] = Boolean.valueOf(tmpStr);
                        ++i;
                    }
                    ++j;
                }
                byte[][] rewardCount = new byte[2][7];
                int j2 = 0;
                while (j2 < 2) {
                    int i = 0;
                    while (i < 7) {
                        String tmpStr = stringConvertor.nextToken();
                        rewardCount[j2][i] = Byte.valueOf(tmpStr);
                        ++i;
                    }
                    ++j2;
                }
                String startLvlStr = null;
                int startLvl = 0;
                try {
                    startLvlStr = stringConvertor.nextToken();
                }
                catch (NoSuchElementException e) {
                    e.printStackTrace();
                }
                if (startLvlStr != null) {
                    startLvl = Integer.parseInt(startLvlStr);
                }
                student = startLvl >= 1 & startLvl <= 14 ? new Student(dataLine, lastName, firstName, age, classLevel, sex, startLvl, sessionNumber, gamesWon, gamesTotal, characAccess, rewardCount) : new Student(dataLine, lastName, firstName, age, classLevel, sex, sessionNumber, gamesWon, gamesTotal, characAccess, rewardCount);
            }
        }
        if (student != null) {
            return student;
        }
        return null;
    }

    public void writeAllStudentListLine(FileWriter fileWriter) {
        if (fileWriter != null) {
            try {
                fileWriter.write(String.valueOf(this.getAttributesCommaDelim()) + "\r\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getDataLine() {
        return this.dataLine;
    }

    public void setDataLine(int dataLine) {
        this.dataLine = dataLine;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setfirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFileHeader() {
        return this.fileHeader;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getClassLevel() {
        return this.classLevel;
    }

    public void setClassLevel(String classLevel) {
        this.classLevel = classLevel;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public String getStartLevelStr() {
        if (this.startLevel == 0) {
            return "?";
        }
        return String.valueOf(this.startLevel);
    }

    public void setStartLevel(int level) {
        this.startLevel = level;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public boolean getCharacAccess(int characID, byte graphicalLevel) {
        return this.characAccess[graphicalLevel][characID];
    }

    public int getNumCharacsUnlocked(byte graphicalLevel) {
        int numCharacsUnlocked = 0;
        int i = 0;
        while (i < 6) {
            if (this.characAccess[graphicalLevel][i]) {
                ++numCharacsUnlocked;
            }
            ++i;
        }
        return numCharacsUnlocked;
    }
}

