/*
 * Decompiled with CFR 0.152.
 */
package algorithms;

import algorithms.AdapDimensions;
import algorithms.GameTurn;
import algorithms.Matrix3D;
import algorithms.NewMultiDimAlg;
import algorithms.NotnDimLevel;
import data.Student;
import graphics.Game;
import java.util.Random;
import org.jmat.data.Matrix;
import util.Utilities;

public class NumCompAlgManager {
    private Game game;
    private NotnDimLevel[] notnDimLevels;
    private NewMultiDimAlg mda;
    private Random randomNumber = new Random();
    public double[] defaultInitialProbs;

    public NumCompAlgManager(Game game, Student student) {
        this.game = game;
        this.randomNumber.setSeed(System.currentTimeMillis());
        this.mda = new NewMultiDimAlg(3, student.getStartLevel());
        this.notnDimLevels = new NotnDimLevel[14];
        this.initializeNotnLevels();
    }

    public void setStimAttributes(GameTurn currentTurn) {
        Matrix currentDifficulty = this.mda.getGeneratedDataPoint();
        currentTurn.setCurrentDifficulty(currentDifficulty);
        currentTurn.setCoordsChosen(this.mda.getCoordsChosen());
        currentTurn.setCurrDesiredDiff(this.mda.getCurrDesir());
        currentTurn.setMeanSuccess(this.mda.getMeanYmat());
        currentTurn.setEstimatedDiff(this.mda.getEdChosen());
        Matrix convCurrDifficulty = new Matrix(1, 3);
        convCurrDifficulty.set(0, 0, AdapDimensions.speedDimension(currentDifficulty.get(0, 0)));
        convCurrDifficulty.set(0, 2, AdapDimensions.notnDimension(currentDifficulty.get(0, 2)));
        if (currentDifficulty.get(0, 0) < 0.3) {
            currentTurn.setDeadlineTrial(false);
        } else {
            currentTurn.setDeadlineTrial(true);
            currentTurn.setCurrentDeadline(convCurrDifficulty.get(0, 0) * 1000.0);
        }
        int currentNotnLevel = (int)convCurrDifficulty.get(0, 2);
        currentTurn.setCurrentNotnLevel(currentNotnLevel);
        int xSide = (int)Math.floor(this.randomNumber.nextInt(2));
        int ySide = Math.abs(xSide - 1);
        Double weberFraction = new Double(0.0);
        int[] xyValues = AdapDimensions.distDimension(currentDifficulty.get(0, 1), this.randomNumber.nextDouble(), this.notnDimLevels[currentNotnLevel].rangeRestriction, weberFraction);
        int[] numbers = new int[2];
        numbers[xSide] = xyValues[0];
        numbers[ySide] = xyValues[1];
        currentTurn.setNumbers(numbers);
        convCurrDifficulty.set(0, 1, weberFraction);
        currentTurn.setConvCurrDifficulty(convCurrDifficulty);
        boolean controlDensity = this.randomNumber.nextBoolean();
        currentTurn.setControlDensity(controlDensity);
        int additionSide = (int)Math.floor(this.randomNumber.nextInt(2));
        int subtractionSide = Utilities.oppositeSide(additionSide);
        currentTurn.setAdditionSide((byte)additionSide);
        int[][] subNumbers = new int[2][2];
        String[] operators = new String[2];
        if (this.notnDimLevels[currentNotnLevel].addition) {
            subNumbers[additionSide][0] = this.randomNumber.nextInt(numbers[additionSide]) + 1;
            subNumbers[additionSide][1] = numbers[additionSide] - subNumbers[additionSide][0];
            operators[additionSide] = "+";
        }
        if (this.notnDimLevels[currentNotnLevel].subtraction) {
            subNumbers[subtractionSide][0] = this.randomNumber.nextInt(10 - numbers[subtractionSide]) + numbers[subtractionSide] + 1;
            subNumbers[subtractionSide][1] = subNumbers[subtractionSide][0] - numbers[subtractionSide];
            operators[subtractionSide] = "-";
        }
        currentTurn.setSubNumbers(subNumbers);
        currentTurn.setOperators(operators);
    }

    public boolean addTrial(Matrix responsePoint) {
        boolean sucessfullyAddedTrial = this.mda.addTrial(responsePoint);
        this.game.dataFileHandler.writeStudentAlgDataFile(this.mda.getModelData(), this.mda.getEdMatrix());
        return sucessfullyAddedTrial;
    }

    private void initializeNotnLevels() {
        this.notnDimLevels[0] = new NotnDimLevel(true, false, false, false, true, false, false, false, 0);
        this.notnDimLevels[1] = new NotnDimLevel(true, false, false, false, false, false, false, false, 0);
        this.notnDimLevels[2] = new NotnDimLevel(true, true, true, false, true, false, false, false, 0);
        this.notnDimLevels[3] = new NotnDimLevel(true, true, true, false, false, false, false, false, 0);
        this.notnDimLevels[4] = new NotnDimLevel(true, true, true, true, false, false, false, false, 4000);
        this.notnDimLevels[5] = new NotnDimLevel(true, true, true, true, false, false, false, false, 1000);
        this.notnDimLevels[6] = new NotnDimLevel(false, true, true, false, false, false, false, false, 0);
        this.notnDimLevels[7] = new NotnDimLevel(false, false, true, false, false, false, false, false, 0);
        this.notnDimLevels[8] = new NotnDimLevel(false, false, true, false, false, true, false, false, 0);
        this.notnDimLevels[9] = new NotnDimLevel(false, false, true, false, true, true, true, false, 0);
        this.notnDimLevels[10] = new NotnDimLevel(false, false, true, false, false, true, true, false, 0);
        this.notnDimLevels[11] = new NotnDimLevel(false, false, true, false, true, true, false, true, 0);
        this.notnDimLevels[12] = new NotnDimLevel(false, false, true, false, false, true, false, true, 0);
        this.notnDimLevels[13] = new NotnDimLevel(false, false, true, false, false, true, true, true, 0);
    }

    public NotnDimLevel getNotnLevel(int level) {
        return this.notnDimLevels[level];
    }

    public void setModelData(Matrix modelData, Matrix3D edMatrix) {
        this.mda.setModelData(modelData);
        this.mda.setEdMatrix(edMatrix);
    }

    public Matrix3D getEdMatrix() {
        return this.mda.getEdMatrix();
    }

    public String getNotnAttrCommaDelim(int currentNotnLevel) {
        return this.notnDimLevels[currentNotnLevel].getAttributesCommaDelim();
    }
}

